/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.trender.gui.widget;

import dev.tr7zw.transition.mc.ComponentProvider;
import dev.tr7zw.trender.gui.impl.client.NarrationMessages;
import dev.tr7zw.trender.gui.widget.WWidget;
import dev.tr7zw.trender.gui.widget.data.Axis;
import dev.tr7zw.trender.gui.widget.data.InputResult;
import java.util.function.IntConsumer;
import lombok.Generated;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;
import trender.xyz.wagyourtail.jvmdg.j21.stub.java_base.J_L_MatchException;

public abstract class WAbstractIntSlider
extends WWidget {
    private static final int DRAGGING_FINISHED_RATE_LIMIT_FOR_SCROLLING = 10;
    protected int min;
    protected int max;
    protected final Axis axis;
    protected Direction direction;
    protected int value;
    protected boolean dragging = false;
    protected float valueToCoordRatio;
    protected float coordToValueRatio;
    private boolean pendingDraggingFinishedFromKeyboard = false;
    private int draggingFinishedFromScrollingTimer = 0;
    private boolean pendingDraggingFinishedFromScrolling = false;
    private boolean ignoreScrolling = false;
    @Nullable
    private IntConsumer valueChangeListener = null;
    @Nullable
    private IntConsumer draggingFinishedListener = null;

    protected WAbstractIntSlider(int min, int max, Axis axis) {
        if (max <= min) {
            throw new IllegalArgumentException("Minimum value must be smaller than the maximum!");
        }
        this.min = min;
        this.max = max;
        this.axis = axis;
        this.value = min;
        this.direction = axis == Axis.HORIZONTAL ? Direction.RIGHT : Direction.UP;
    }

    protected abstract int getThumbWidth();

    protected abstract boolean isMouseInsideBounds(int var1, int var2);

    protected void updateValueCoordRatios() {
        int trackHeight = (this.axis == Axis.HORIZONTAL ? this.getWidth() : this.getHeight()) - this.getThumbWidth();
        this.valueToCoordRatio = (float)(this.max - this.min) / (float)trackHeight;
        this.coordToValueRatio = 1.0f / this.valueToCoordRatio;
    }

    @Override
    public void setSize(int x, int y) {
        super.setSize(x, y);
        this.updateValueCoordRatios();
    }

    @Override
    public boolean canResize() {
        return true;
    }

    @Override
    public boolean canFocus() {
        return true;
    }

    @Override
    public InputResult onMouseDown(int x, int y, int button) {
        if (this.isMouseInsideBounds(x, y)) {
            this.requestFocus();
            return InputResult.PROCESSED;
        }
        return InputResult.IGNORED;
    }

    @Override
    public InputResult onMouseDrag(int x, int y, int button, double deltaX, double deltaY) {
        if (this.isFocused()) {
            this.dragging = true;
            this.moveSlider(x, y);
            return InputResult.PROCESSED;
        }
        return InputResult.IGNORED;
    }

    @Override
    public InputResult onClick(int x, int y, int button) {
        this.moveSlider(x, y);
        if (this.draggingFinishedListener != null) {
            this.draggingFinishedListener.accept(this.value);
        }
        return InputResult.PROCESSED;
    }

    private void moveSlider(int x, int y) {
        int axisPos = switch (this.direction.ordinal()) {
            default -> throw new J_L_MatchException(null, null);
            case 0 -> this.getHeight() - y;
            case 1 -> y;
            case 2 -> this.getWidth() - x;
            case 3 -> x;
        };
        int pos = axisPos - this.getThumbWidth() / 2;
        int rawValue = this.min + Math.round(this.valueToCoordRatio * (float)pos);
        int previousValue = this.value;
        this.value = class_3532.method_15340((int)rawValue, (int)this.min, (int)this.max);
        if (this.value != previousValue) {
            this.onValueChanged(this.value);
        }
    }

    @Override
    public InputResult onMouseUp(int x, int y, int button) {
        this.dragging = false;
        if (this.draggingFinishedListener != null) {
            this.draggingFinishedListener.accept(this.value);
        }
        return InputResult.PROCESSED;
    }

    @Override
    public InputResult onMouseScroll(int x, int y, double horizontalAmount, double verticalAmount) {
        if (this.ignoreScrolling) {
            return InputResult.IGNORED;
        }
        if (this.direction == Direction.LEFT || this.direction == Direction.DOWN) {
            verticalAmount = -verticalAmount;
        }
        int previous = this.value;
        this.value = class_3532.method_15340((int)(this.value + (int)Math.signum(verticalAmount) * class_3532.method_15384((double)((double)this.valueToCoordRatio * Math.abs(verticalAmount) * 2.0))), (int)this.min, (int)this.max);
        if (previous != this.value) {
            this.onValueChanged(this.value);
            this.pendingDraggingFinishedFromScrolling = true;
        }
        return InputResult.PROCESSED;
    }

    @Override
    public void tick() {
        if (this.draggingFinishedFromScrollingTimer > 0) {
            --this.draggingFinishedFromScrollingTimer;
        }
        if (this.pendingDraggingFinishedFromScrolling && this.draggingFinishedFromScrollingTimer <= 0) {
            if (this.draggingFinishedListener != null) {
                this.draggingFinishedListener.accept(this.value);
            }
            this.pendingDraggingFinishedFromScrolling = false;
            this.draggingFinishedFromScrollingTimer = 10;
        }
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.setValue(value, false);
    }

    public void setValue(int value, boolean callListeners) {
        int previous = this.value;
        this.value = class_3532.method_15340((int)value, (int)this.min, (int)this.max);
        if (callListeners && previous != this.value) {
            this.onValueChanged(this.value);
            if (this.draggingFinishedListener != null) {
                this.draggingFinishedListener.accept(value);
            }
        }
    }

    @Nullable
    public IntConsumer getValueChangeListener() {
        return this.valueChangeListener;
    }

    public void setValueChangeListener(@Nullable IntConsumer valueChangeListener) {
        this.valueChangeListener = valueChangeListener;
    }

    @Nullable
    public IntConsumer getDraggingFinishedListener() {
        return this.draggingFinishedListener;
    }

    public void setDraggingFinishedListener(@Nullable IntConsumer draggingFinishedListener) {
        this.draggingFinishedListener = draggingFinishedListener;
    }

    public int getMinValue() {
        return this.min;
    }

    public int getMaxValue() {
        return this.max;
    }

    public void setMinValue(int min) {
        this.min = min;
        this.updateValueCoordRatios();
        if (this.value < min) {
            this.value = min;
            this.onValueChanged(this.value);
        }
    }

    public void setMaxValue(int max) {
        this.max = max;
        this.updateValueCoordRatios();
        if (this.value > max) {
            this.value = max;
            this.onValueChanged(this.value);
        }
    }

    public Axis getAxis() {
        return this.axis;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        if (direction.getAxis() != this.axis) {
            throw new IllegalArgumentException("Incorrect axis: " + String.valueOf((Object)this.axis));
        }
        this.direction = direction;
    }

    protected void onValueChanged(int value) {
        if (this.valueChangeListener != null) {
            this.valueChangeListener.accept(value);
        }
    }

    @Override
    public InputResult onKeyPressed(int ch, int key, int modifiers) {
        boolean valueChanged = false;
        if (modifiers == 0) {
            if (WAbstractIntSlider.isDecreasingKey(ch, this.direction) && this.value > this.min) {
                --this.value;
                valueChanged = true;
            } else if (WAbstractIntSlider.isIncreasingKey(ch, this.direction) && this.value < this.max) {
                ++this.value;
                valueChanged = true;
            }
        } else if (modifiers == 2) {
            if (WAbstractIntSlider.isDecreasingKey(ch, this.direction) && this.value != this.min) {
                this.value = this.min;
                valueChanged = true;
            } else if (WAbstractIntSlider.isIncreasingKey(ch, this.direction) && this.value != this.max) {
                this.value = this.max;
                valueChanged = true;
            }
        }
        if (valueChanged) {
            this.onValueChanged(this.value);
            this.pendingDraggingFinishedFromKeyboard = true;
        }
        return InputResult.of(valueChanged);
    }

    @Override
    public InputResult onKeyReleased(int ch, int key, int modifiers) {
        if (this.pendingDraggingFinishedFromKeyboard && (WAbstractIntSlider.isDecreasingKey(ch, this.direction) || WAbstractIntSlider.isIncreasingKey(ch, this.direction))) {
            if (this.draggingFinishedListener != null) {
                this.draggingFinishedListener.accept(this.value);
            }
            this.pendingDraggingFinishedFromKeyboard = false;
            return InputResult.PROCESSED;
        }
        return InputResult.IGNORED;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    @Override
    public void addNarrations(class_6382 builder) {
        builder.method_37034(class_6381.field_33788, (class_2561)ComponentProvider.translatable((String)"widget.libgui.slider.narration.title", (Object[])new Object[]{this.value, this.min, this.max}));
        builder.method_37034(class_6381.field_33791, NarrationMessages.SLIDER_USAGE);
    }

    public static boolean isDecreasingKey(int ch, Direction direction) {
        return direction.isInverted() ? ch == 262 || ch == 265 : ch == 263 || ch == 264;
    }

    public static boolean isIncreasingKey(int ch, Direction direction) {
        return direction.isInverted() ? ch == 263 || ch == 264 : ch == 262 || ch == 265;
    }

    @Generated
    public boolean isIgnoreScrolling() {
        return this.ignoreScrolling;
    }

    @Generated
    public void setIgnoreScrolling(boolean ignoreScrolling) {
        this.ignoreScrolling = ignoreScrolling;
    }

    public static enum Direction {
        UP(Axis.VERTICAL, false),
        DOWN(Axis.VERTICAL, true),
        LEFT(Axis.HORIZONTAL, true),
        RIGHT(Axis.HORIZONTAL, false);

        private final Axis axis;
        private final boolean inverted;

        private Direction(Axis axis, boolean inverted) {
            this.axis = axis;
            this.inverted = inverted;
        }

        public Axis getAxis() {
            return this.axis;
        }

        public boolean isInverted() {
            return this.inverted;
        }
    }
}

